<?php

//content
$this->start_controls_section(
    'layout_two_content',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_two_summary',
    [
        'label' => __('Summary', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Text', 'apsro-addon'),
        'default' => __('Default Summary Text', 'apsro-addon'),
    ]
);

$this->add_control(
    'about_two_summary_hr',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);


$this->add_control(
    'layout_two_feature_title',
    [
        'label' => __('Feature Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'placeholder' => __('Add Feature Title', 'apsro-addon'),
        'default' => __('Default Feature Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Feature Title', 'h3', 'layout_two');

$this->add_control(
    'layout_two_feature_sub_title',
    [
        'label' => __('Feature Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'placeholder' => __('Add Feature Sub Title', 'apsro-addon'),
        'default' => __('Default Feature Sub Title', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_two_feature_icon',
    [
        'label' => __('Feature Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-targeted-marketing',
            'library' => 'custom-icon',
        ],
        'label_block' => true,
    ]
);

$this->add_control(
    'about_two_feature_hr',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$layout_two_check_list = new \Elementor\Repeater();

$layout_two_check_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa fa-check',
            'library' => 'custom-icon',
        ],
        'label_block' => true,
    ]
);

$layout_two_check_list->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_two_check_list',
    [
        'label' => __('Choose List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_check_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_two_button_label',
    [
        'label' => __('Button Label', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Contact Now', 'apsro-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'button_two_button_url',
    [
        'label' => __('Button Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_two_section_image',
    [
        'label' => __('Images & Rounded Text Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_image_one',
    [
        'label' => __('Image One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_two_image_two',
    [
        'label' => __('Image Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_two_rounded_text',
    [
        'label' => __('Rounded Text', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'placeholder' => __('Add rounded text', 'apsro-addon'),
        'default' => __('Default rounded text', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_two_rounded_box_icon',
    [
        'label' => __('Rounded Box Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-management',
            'library' => 'custom-icon',
        ],
    ]
);

$this->end_controls_section();
