<?php
$this->start_controls_section(
    'header_title',
    [
        'label' => __('Blog Header', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_three']
        ]
    ]
);


$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');


$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'post_option',
    [
        'label' => __('Post Options', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$this->add_control(
    'post_count',
    [
        'label' => __('Number Of Posts', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 0,
                'max' => 15,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 6,
        ],
    ]
);


$this->add_control(
    'query_order',
    [
        'label' => __('Select Order', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'default' => 'DESC',
        'options' => [
            'DESC' => __('DESC', 'apsro-addon'),
            'ASC' => __('ASC', 'apsro-addon'),
        ]
    ]
);

$this->add_control(
    'select_category',
    [
        'label' => __('Post Category', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => apsro_get_taxonoy('category'),
    ]
);

$this->add_control(
    'pagination_status',
    [
        'label' => __('Enable Pagination?', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'apsro-addon'),
        'label_off' => __('No', 'apsro-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);

$this->add_control(
    'read_more',
    [
        'label' => __('Read More', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('More', 'apsro-addon'),
        'label_block' => true,
    ]
);


$this->add_control(
    'blog_icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-lg-arrow',
            'library' => 'font-awesome',
        ],
    ]
);

$this->end_controls_section();
