<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Title', 'h3', 'layout_three');

$this->add_control(
    'layout_three_phone_text',
    [
        'label' => __('Phone Text', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Phone Text', 'apsro-addon'),
        'default' => __('Have Questions?', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_three_phone_number',
    [
        'label' => __('Number', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Number', 'apsro-addon'),
        'default' => __('+92 (666) 888 0000', 'apsro-addon'),
    ]
);


$this->add_control(
    'layout_three_phone_url',
    [
        'label' => __('Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add Url', 'apsro-addon'),
        'default' => __('#', 'apsro-addon'),
        'label_block' => true
    ]
);


$this->add_control(
    'layout_three_icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-call',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_three_button_label',
    [
        'label' => __('Button Label', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Contact Now', 'apsro-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_three_button_url',
    [
        'label' => __('Button Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);


$this->add_control(
    'layout_three_image',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'layout_three_shape',
    [
        'label' => __('Shape', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);


$this->end_controls_section();
