<?php

//content
$this->start_controls_section(
    'content_two',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_two_choose_section_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$layout_two_choose_list = new \Elementor\Repeater();

$layout_two_choose_list->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
        'label_block' => true
    ]
);

$layout_two_choose_list->add_control(
    'summary',
    [
        'label' => __('Summary', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add summary', 'apsro-addon'),
        'default' => __('Default Summary', 'apsro-addon'),
    ]
);

$layout_two_choose_list->add_control(
    'check_list',
    [
        'label' => __('Check List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'placeholder' => __('Add check list', 'apsro-addon'),
        'default' => __('<li> <div class="icon"> <span class="fa fa-check"></span> </div> <div class="text"> <p>Maecenas id amet some</p> </div> </li>', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_two_choose_list',
    [
        'label' => __('Choose Lists', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_choose_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_two_choose_list_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'layout_two_image_one',
    [
        'label' => __('Image One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'layout_two_image_two',
    [
        'label' => __('Image Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'layout_two_image_three',
    [
        'label' => __('Image Three', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->end_controls_section();
