<?php

$this->start_controls_section(
    'layout_four_contact_form',
    [
        'label' => __('Contact Form', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_four'
        ]
    ]
);

$this->add_control(
    'layout_four_sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_four');

$this->add_control(
    'layout_four_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);


$layout_four_contact_info = new \Elementor\Repeater();

$layout_four_contact_info->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-help',
            'library' => 'custom',
        ],
        'label_block' => true,
    ]
);

$layout_four_contact_info->add_control(
    'contact_title',
    [
        'label' => __('Contact Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Title', 'apsro-addon'),
        'label_block' => true,
    ]
);

$layout_four_contact_info->add_control(
    'contact_number',
    [
        'label' => __('Contact Number', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('<a href="tel:8898006802">Free +88 (9800) 6802</a>', 'apsro-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_four_contact_info',
    [
        'label' => __('Contact List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_four_contact_info->get_controls(),
        'title_field' => '{{{ contact_title }}}',
        'prevent_empty' => false,
    ]
);

$layout_four_social = new \Elementor\Repeater();

$layout_four_social->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-facebook-f',
            'library' => 'brand',
        ],
        'label_block' => true,
    ]
);

$layout_four_social->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_four_social',
    [
        'label' => __('Social Icons', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_four_social->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],

    ]
);

$this->add_control(
    'layout_four_select_wpcf7_form',
    [
        'label'       => esc_html__('Select your contact form 7', 'apsro-addon'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT,
        'options'     => apsro_post_query('wpcf7_contact_form'),
    ]
);

$this->end_controls_section();
