<?php

$this->start_controls_section(
    'content_top_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$layout_one_info_items = new \Elementor\Repeater();

$layout_one_info_items->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Title', 'apsro-addon'),
        'label_block' => true,
    ]
);

$layout_one_info_items->add_control(
    'content',
    [
        'label' => __('Content', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'label_block' => true,
        'default' => wp_kses(__('<a href="tel:+9212340800"><span>Free</span> +92 (1234) 0800</a>'), 'apsro_allowed_tags')
    ]
);

apsro_elementor_heading_option($layout_one_info_items, 'Content', 'h4', 'layout_one');

$layout_one_info_items->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-help',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'layout_one_info_items',
    [
        'label' => __('Contact Info', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_info_items->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$layout_one_social = new \Elementor\Repeater();

$layout_one_social->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-facebook-f',
            'library' => 'brand',
        ],
        'label_block' => true,
    ]
);

$layout_one_social->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_one_social',
    [
        'label' => __('Social Icons', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_social->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],

    ]
);

$this->add_control(
    'background_image_one',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->end_controls_section();
