<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$counter_list = new \Elementor\Repeater();

$counter_list->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

$counter_list->add_control(
    'number',
    [
        'label' => __('Number', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Number', 'apsro-addon'),
        'default' => __('82', 'apsro-addon'),
    ]
);

$counter_list->add_control(
    'symbol',
    [
        'label' => __('Symbol', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Symbol', 'apsro-addon'),
        'default' => __('k', 'apsro-addon'),
    ]
);

$counter_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-new-project',
            'library' => 'custom-icon',
        ],
    ]
);


$this->add_control(
    'counter_list',
    [
        'label' => __('Count Lists', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $counter_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->add_control(
    'bg_image',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
