<?php

//content
$this->start_controls_section(
    'content_five',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);

$feature_list = new \Elementor\Repeater();

$feature_list->add_control(
    'content',
    [
        'label' => __('Content', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<span>*</span> Transform Ideas', 'apsro_allowed_tags')
    ]
);

apsro_elementor_heading_option($feature_list, 'Feature Content', 'h2', 'layout_five');

$this->add_control(
    'layout_five_feature_list',
    [
        'label' => __('Feature Lists', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $feature_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ content }}}',
    ]
);

$this->end_controls_section();
