<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'logo',
    [
        'label' => __('Add Logo', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'logo_dimension',
    [
        'label' => __('Logo Dimension', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
        'description' => __('Set Custom Logo Size.', 'apsro-addon'),
        'default' => [
            'width' => '134',
            'height' => '34',
        ],
    ]
);

$this->add_control(
    'text',
    [
        'label' => __('Text', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add paragraph text', 'apsro-addon'),
        'default' => __('Default text', 'apsro-addon'),
    ]
);

$this->end_controls_section();
