<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'title',
    [
        'label' => __('Add Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Title', 'apsro-addon')
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h3', 'layout_one');

$this->add_control(
    'subtitle',
    [
        'label' => __('Add Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Sub Title', 'apsro-addon')
    ]
);

$footer_contact_list = new \Elementor\Repeater();

$footer_contact_list->add_control(
    'content',
    [
        'label' => __('Content', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Content', 'apsro-addon'),
        'default' => __('<a href="mailto:hello@company.com">hello@company.com</a>', 'apsro-addon'),
    ]
);

$this->add_control(
    'footer_contact_list',
    [
        'label' => __('Contact Info', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $footer_contact_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ content }}}',
    ]
);

$this->end_controls_section();
