<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$this->add_control(
    'title',
    [
        'label' => __('Widget Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Newsletter', 'apsro-addon'),
        'label_block' => true
    ]
);

apsro_elementor_heading_option($this, 'Widget Title', 'h3', 'layout_one');

$this->add_control(
    'text',
    [
        'label' => __('Text', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Text', 'apsro-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'mailchimp_url',
    [
        'label' => __('Add Mailchimp URL', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
        'label_block' => true
    ]
);

$this->add_control(
    'mc_input_placeholder',
    [
        'label' => __('Input Placeholder Text', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Email address', 'apsro-addon'),
        'label_block' => true
    ]
);

$layout_one_social = new \Elementor\Repeater();

$layout_one_social->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-facebook-f',
            'library' => 'brand',
        ],
        'label_block' => true,
    ]
);

$layout_one_social->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_one_social',
    [
        'label' => __('Social Icons', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_social->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],

    ]
);

$this->end_controls_section();
