<?php

$this->start_controls_section(
    'logo_section',
    [
        'label' => __('Site Logo', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'light_logo',
    [
        'label' => __('Light Logo', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'logo_dimension',
    [
        'label' => __('Logo Dimension', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
        'description' => __('Set Custom Logo Size.', 'apsro-addon'),
        'default' => [
            'width' => '39',
            'height' => '45',
        ],
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'nav_section',
    [
        'label' => __('Navigation', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'nav_menu',
    [
        'label' => __('Select Nav Menu', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => apsro_get_nav_menu(),
        'label_block' => true,
    ]
);

$this->end_controls_section();

//other
$this->start_controls_section(
    'others_section',
    [
        'label' => __('Others', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$this->add_control(
    'search_enable',
    [
        'label' => __('Enable Search?', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'apsro-addon'),
        'label_off' => __('No', 'apsro-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$this->add_control(
    'cart_enable',
    [
        'label' => __('Enable Cart?', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'apsro-addon'),
        'label_off' => __('No', 'apsro-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$this->add_control(
    'button_label',
    [
        'label' => __('Quote Button Label', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Get Free Quote', 'apsro-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'url',
    [
        'label' => __('Button Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => true,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'mobile_menu_section',
    [
        'label' => __('Mobile Drawer', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);


$this->add_control(
    'mobile_menu_logo',
    [
        'label' => __('Mobile Drawer Logo', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'mobile_email',
    [
        'label' => __('Email', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Email', 'apsro-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'mobile_phone',
    [
        'label' => __('Phone', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Phone Number', 'apsro-addon'),
        'label_block' => true,
    ]
);

$mobile_menu_social_icons = new \Elementor\Repeater();

$mobile_menu_social_icons->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => apsro_get_fa_icons(),
        'default' => 'fa-facebook-f',
        'label_block' => true,
    ]
);

$mobile_menu_social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'mobile_menu_social_icons',
    [
        'label' => __('Social Icons', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $mobile_menu_social_icons->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_icon' => 'fa-facebook-f',
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
        'title_field' => '{{{ social_icon }}}',
    ]
);

$this->end_controls_section();
