<?php

$this->start_controls_section(
    'content_section_two',
    [
        'label' => __('History Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_icon',
    [
        'label' => __('Section Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa fa-star',
            'library' => 'font-awesome',
        ],
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_two');


$history_two = new \Elementor\Repeater();

$history_two->add_control(
    'date',
    [
        'label' => __('Date', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '1',
        'placeholder' => __('Date', 'apsro-addon'),
        'default' => __('2023', 'apsro-addon'),
    ]
);

$history_two->add_control(
    'title_one',
    [
        'label' => __('Title One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Title One', 'apsro-addon'),
        'default' => __('Default Title One', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($history_two, 'History Title One', 'h3', 'layout_two');

$history_two->add_control(
    'subtitle_one',
    [
        'label' => __('Subtitle One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Subtitle One', 'apsro-addon'),
        'default' => __('Default Subtitle One', 'apsro-addon'),
    ]
);

$history_two->add_control(
    'summary_one',
    [
        'label' => __('Summary', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Summary', 'apsro-addon'),
        'default' => __('Default Summary', 'apsro-addon'),
    ]
);

$history_two->add_control(
    'image_one',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$history_two->add_control(
    'title_two',
    [
        'label' => __('Title Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Title Two', 'apsro-addon'),
        'default' => __('Default Title Two', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($history_two, 'History Title Two', 'h3', 'layout_two');

$history_two->add_control(
    'subtitle_two',
    [
        'label' => __('Subtitle Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Subtitle Two', 'apsro-addon'),
        'default' => __('Default Subtitle Two', 'apsro-addon'),
    ]
);

$history_two->add_control(
    'summary_two',
    [
        'label' => __('Summary', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Summary Two', 'apsro-addon'),
        'default' => __('Default Summary Two', 'apsro-addon'),
    ]
);

$history_two->add_control(
    'image_Two',
    [
        'label' => __('Image Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);


$this->add_control(
    'history_two_list',
    [
        'label' => __('History List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $history_two->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ date }}}',
    ]
);

$this->end_controls_section();
