<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Slider Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$sliders = new \Elementor\Repeater();

$sliders->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($sliders, 'Title', 'h2', 'layout_one');

$sliders->add_control(
    'sub_title',
    [
        'label' => __('Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add paragraph text', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

$sliders->add_control(
    'star_icon',
    [
        'label' => __('Star Text', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add star text', 'apsro-addon'),
        'default' => __('*', 'apsro-addon'),
    ]
);

$sliders->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-arrow1',
            'library' => 'font-awesome',
        ],
    ]
);

$sliders->add_control(
    'button_url',
    [
        'label' => __('Button Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);


$sliders->add_control(
    'background_image',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'sliders',
    [
        'label' => __('Main Slider', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $sliders->get_controls(),
        'title_field' => '{{{ title }}}',
        'prevent_empty' => false,
    ]
);

$this->add_control(
    'slider_one_phone',
    [
        'label' => __('Phone', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add phone text', 'apsro-addon'),
        'default' => __('<a href="tel:926668880000">+92 (666) 888 0000</a>', 'apsro-addon'),
    ]
);

$this->add_control(
    'slider_one_mail',
    [
        'label' => __('Mail', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add mail text', 'apsro-addon'),
        'default' => __('<a href="mailto:hello@company.com">hello@company.com</a>', 'apsro-addon'),
    ]
);


$this->end_controls_section();
