<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Slider Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_title_one',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Title One', 'apsro-addon'),
        'default' => __('Default Title One', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Title One', 'h2', 'layout_three');

$this->add_control(
    'layout_three_title_two',
    [
        'label' => __('Title Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Title Two', 'apsro-addon'),
        'default' => __('Default Title Two', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Title Two', 'h2', 'layout_three');

$this->add_control(
    'layout_three_phone',
    [
        'label' => __('Phone', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add phone text', 'apsro-addon'),
        'default' => __('<a href="tel:926668880000">+92 (666) 888 0000</a>', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_three_mail',
    [
        'label' => __('Mail', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add mail text', 'apsro-addon'),
        'default' => __('<a href="mailto:hello@company.com">hello@company.com</a>', 'apsro-addon'),
    ]
);


$this->add_control(
    'layout_three_image_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);


$this->add_control(
    'layout_three_background_image',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_three_shape_one',
    [
        'label' => __('Shape One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_three_image_one',
    [
        'label' => __('Bottom Image One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_three_image_two',
    [
        'label' => __('Bottom Image Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
