<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Slider Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$layout_two_sliders = new \Elementor\Repeater();

$layout_two_sliders->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($layout_two_sliders, 'Title', 'h2', 'layout_two');

$layout_two_sliders->add_control(
    'title_two',
    [
        'label' => __('Title Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Awesome Title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($layout_two_sliders, 'Title Two', 'h2', 'layout_two');

$layout_two_sliders->add_control(
    'sub_title',
    [
        'label' => __('Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add paragraph text', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

$layout_two_sliders->add_control(
    'url',
    [
        'label' => __('Button Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$layout_two_sliders->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-arrow1',
            'library' => 'font-awesome',
        ],
    ]
);

$layout_two_sliders->add_control(
    'background_image',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_two_sliders->add_control(
    'image_one',
    [
        'label' => __('Image One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_two_sliders->add_control(
    'image_two',
    [
        'label' => __('Image Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_two_sliders->add_control(
    'shape_one',
    [
        'label' => __('Shape One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$layout_two_sliders->add_control(
    'shape_two',
    [
        'label' => __('Shape Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'layout_two_sliders',
    [
        'label' => __('Main Slider', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_sliders->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'slider_two_phone',
    [
        'label' => __('Phone', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add phone text', 'apsro-addon'),
        'default' => __('<a href="tel:926668880000">+92 (666) 888 0000</a>', 'apsro-addon'),
    ]
);

$this->add_control(
    'slider_two_mail',
    [
        'label' => __('Mail', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add mail text', 'apsro-addon'),
        'default' => __('<a href="mailto:hello@company.com">hello@company.com</a>', 'apsro-addon'),
    ]
);

$this->end_controls_section();
