<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_one');

$measurement_list = new \Elementor\Repeater();

$measurement_list->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Default Title', 'apsro-addon'),
        'label_block' => true,
    ]
);

apsro_elementor_heading_option($measurement_list, 'Measurement Title', 'h4', 'layout_one');

$measurement_list->add_control(
    'summary',
    [
        'label' => __('Summary', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Sub Title', 'apsro-addon'),
        'label_block' => true,
    ]
);

$measurement_list->add_control(
    'image',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$measurement_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-living-room',
            'library' => 'custom-icon',
        ],
    ]
);

$measurement_list->add_control(
    'points',
    [
        'label' => __('points', 'ogenix-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
    ]
);

$this->add_control(
    'measurement_list',
    [
        'label' => __('Measurement Items', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $measurement_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->end_controls_section();
