<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');


$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_one');


$neighbour_faq = new \Elementor\Repeater();

$neighbour_faq->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
        'label_block' => true,
    ]
);

apsro_elementor_heading_option($neighbour_faq, 'Accordian Title', 'h4', 'layout_one');

$neighbour_faq->add_control(
    'sub_title',
    [
        'label' => __('Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Sub Title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
        'label_block' => true,
    ]
);

$neighbour_faq->add_control(
    'summary',
    [
        'label' => __('Summary', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Summary', 'apsro-addon'),
        'default' => __('Default Summary', 'apsro-addon'),
        'label_block' => true,
    ]
);

$neighbour_faq->add_control(
    'active_status',
    [
        'label' => __('Is active?', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'apsro-addon'),
        'label_off' => __('No', 'apsro-addon'),
        'return_value' => 'yes',
        'default' => 'no',
    ]
);


$this->add_control(
    'neighbour_faq_lists',
    [
        'label' => __('Neighborhood List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $neighbour_faq->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'bac_image_one',
    [
        'label' => __('Backround Image One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->add_control(
    'bac_image_two',
    [
        'label' => __('Backround Image Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);


$this->end_controls_section();
