<?php

$this->start_controls_section(
    'content__five_section',
    [
        'label' => __('Portfolio Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);

$portfolio_five = new \Elementor\Repeater();

$portfolio_five->add_control(
    'image',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$portfolio_five->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-plus',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'portfolio_five_list',
    [
        'label' => __('Portfolio List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $portfolio_five->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();
