<?php

$this->start_controls_section(
    'layout_six_content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_six'
        ]
    ]
);

$this->add_control(
    'layout_six_sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_six');

$this->add_control(
    'layout_six_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_six');

$portfolio_six = new \Elementor\Repeater();

$portfolio_six->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($portfolio_six, 'Portfolio Title', 'h4', 'layout_six');

$portfolio_six->add_control(
    'tag_line',
    [
        'label' => __('Tag Line', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Tag Line', 'apsro-addon'),
        'default' => __('Default Tag Line', 'apsro-addon'),
    ]
);

$portfolio_six->add_control(
    'image',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$portfolio_six->add_control(
    'url',
    [
        'label' => __('Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'portfolio_six_list',
    [
        'label' => __('Portfolio List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $portfolio_six->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->end_controls_section();
