<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Pricing Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);
$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);


$this->add_control(
    'pricing_layout_one_pricing_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'monthly_heading',
    [
        'label' => __('Monthly Heading', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Monthly', 'apsro-addon'),
        'default' => __('Monthly', 'apsro-addon'),
    ]
);

$this->add_control(
    'yearly_heading',
    [
        'label' => __('Yearly Heading', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Yearly', 'apsro-addon'),
        'default' => __('Yearly', 'apsro-addon'),
    ]
);

$pricing_monthly_list = new \Elementor\Repeater();

$pricing_monthly_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Plan', 'apsro-addon'),
        'default' => __('Default Plan', 'apsro-addon'),
    ]
);

$pricing_monthly_list->add_control(
    'price',
    [
        'label' => __('Price', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$69', 'apsro-addon'),
    ]
);

$pricing_monthly_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-pen-tool',
            'library' => 'custom-icon',
        ],
    ]
);

$pricing_monthly_list->add_control(
    'service_title',
    [
        'label' => __('Service Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Service Title', 'apsro-addon'),
        'default' => __('Default Service Title', 'apsro-addon'),
    ]
);

$pricing_monthly_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><div class="icon"><i class="fa fa-check"></i></div><div class="text"><p>10 Days Time</p></div></li>', 'apsro_allowed_tags')
    ]
);

$pricing_monthly_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Apply Now', 'apsro-addon'),
        'label_block' => true,
    ]
);

$pricing_monthly_list->add_control(
    'url',
    [
        'label' => __('Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'pricing_monthly_list',
    [
        'label' => __('Monthly List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $pricing_monthly_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->add_control(
    'pricing_layout_one_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$pricing_yearly_list = new \Elementor\Repeater();

$pricing_yearly_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Plan', 'apsro-addon'),
        'default' => __('Default Plan', 'apsro-addon'),
    ]
);

$pricing_yearly_list->add_control(
    'price',
    [
        'label' => __('Price', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$499', 'apsro-addon'),
    ]
);

$pricing_yearly_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-pen-tool',
            'library' => 'custom-icon',
        ],
    ]
);

$pricing_yearly_list->add_control(
    'service_title',
    [
        'label' => __('Service Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Service Title', 'apsro-addon'),
        'default' => __('Default Service Title', 'apsro-addon'),
    ]
);

$pricing_yearly_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><div class="icon"><i class="fa fa-check"></i></div><div class="text"><p>10 Days Time</p></div></li>', 'apsro_allowed_tags')
    ]
);

$pricing_yearly_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Apply Now', 'apsro-addon'),
        'label_block' => true,
    ]
);

$pricing_yearly_list->add_control(
    'url',
    [
        'label' => __('Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'pricing_yearly_list',
    [
        'label' => __('Yearly List', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $pricing_yearly_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->end_controls_section();
