<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Sub Title', 'apsro-addon'),
    ]
);

$this->add_control(
    'layout_two_summary',
    [
        'label' => __('Section Summary ', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Text', 'apsro-addon'),
    ]
);

$layout_two_service = new \Elementor\Repeater();

$layout_two_service->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Awesome Title', 'apsro-addon'),
        'label_block' => true,
    ]
);

$layout_two_service->add_control(
    'icon',
    [
        'label' => __('Section Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-software-development',
            'library' => 'custom-icon',
        ],
    ]
);

$layout_two_service->add_control(
    'url',
    [
        'label' => __('Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
    ]
);

$this->add_control(
    'layout_two_service_items',
    [
        'label' => __('Service Items', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_service->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'layout_two_image',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
    ]
);

$this->end_controls_section();
