<?php

$this->start_controls_section(
    'content_section_two',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'sec_title_two',
    [
        'label' => __('Add Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h4', 'layout_two');

$this->add_control(
    'call_text_two',
    [
        'label' => __('Add Call Text', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Call Anytime', 'apsro-addon'),
    ]
);

$this->add_control(
    'phone_number_two',
    [
        'label' => __('Phone Number', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<a href="tel:9288009850">+92 (8800) - 9850</a>', 'apsro_allowed_tags')
    ]
);

$this->add_control(
    'sec_icon_two',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-phone-call',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'background_image_two',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
