<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);


$tab_list = new \Elementor\Repeater();

$tab_list->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Individual Therapy', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($tab_list, 'Title', 'h3', 'layout_one');

$tab_list->add_control(
    'summary',
    [
        'label' => __('Summary', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'apsro-addon'),
        'default' => __('Default Text', 'apsro-addon'),
    ]
);

$tab_list->add_control(
    'feature',
    [
        'label' => __('Feature', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'rows' => '2',
        'placeholder' => __('Add Feature', 'apsro-addon'),
        'default' => __('<li><div class="icon"><span class="fa fa-check"></span></div><div class="text"><p>Nsectetur cing elit</p></div></li>', 'apsro-addon'),
    ]
);


$tab_list->add_control(
    'image',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'tab_list',
    [
        'label' => __('Tab Lists', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $tab_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'shape',
    [
        'label' => __('Shape', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
