<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Top Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'name',
    [
        'label' => __('Name', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add name', 'apsro-addon'),
        'default' => __('Default Name', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Name', 'h3', 'layout_one');

$this->add_control(
    'designation',
    [
        'label' => __('Designation', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add designation', 'apsro-addon'),
        'default' => __('Default Designation', 'apsro-addon'),
    ]
);

$this->add_control(
    'summary',
    [
        'label' => __('Summary One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Text', 'apsro-addon'),
        'default' => __('Default Summary Text', 'apsro-addon'),
    ]
);

$this->add_control(
    'social_lists_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$social_icons = new \Elementor\Repeater();

$social_icons->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-facebook-f',
            'library' => 'brand',
        ],
        'label_block' => true,
    ]
);

$social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'social_icons',
    [
        'label' => __('Social Icons', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $social_icons->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
    ]
);

$this->add_control(
    'bg_image',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'point_list_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'point_list_title',
    [
        'label' => __('Point Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Point List Title', 'apsro-addon'),
        'default' => __('Default Point List Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Point Title', 'h3', 'layout_one');

$point_list = new \Elementor\Repeater();

$point_list->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

$point_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa fa-check',
            'library' => 'font-awesome',
        ],
    ]
);

$this->add_control(
    'point_list',
    [
        'label' => __('Point List One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $point_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'progress_list_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$point_list_two = new \Elementor\Repeater();

$point_list_two->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

$point_list_two->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fa fa-check',
            'library' => 'font-awesome',
        ],
    ]
);

$this->add_control(
    'point_list_two',
    [
        'label' => __('Point List Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $point_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->add_control(
    'progress_list_two_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$progress_list = new \Elementor\Repeater();

$progress_list->add_control(
    'title',
    [
        'label' => __('Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

$progress_list->add_control(
    'number',
    [
        'label' => __('Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add Number', 'apsro-addon'),
        'default' => __('66%', 'apsro-addon'),
    ]
);

$this->add_control(
    'progress_list',
    [
        'label' => __('Progress Lists', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $progress_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
