<?php

$this->start_controls_section(
    'layout_one_content',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Sub Title', 'p', 'layout_one');

$team = new \Elementor\Repeater();

$team->add_control(
    'name',
    [
        'label' => __('Name', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Michale smith', 'apsro-addon'),
        'label_block' => true,
    ]
);

apsro_elementor_heading_option($team, 'Team Name', 'h3', 'layout_one');

$team->add_control(
    'designation',
    [
        'label' => __('Designation', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Mayor', 'apsro-addon'),
    ]
);

$team->add_control(
    'url',
    [
        'label' => __('Url', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'apsro-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => true,
    ]
);

$team->add_control(
    'social_network',
    [
        'label' => __('Social NetWork', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><a href="#"><i class="fab fa-instagram"></i></a></li>', 'apsro_allowed_tags')
    ]
);


$team->add_control(
    'image',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$team->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-right-lg-arrow',
            'library' => 'custom-icon',
        ],
    ]
);

$this->add_control(
    'team_items',
    [
        'label' => __('Team', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $team->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
    ]
);

$this->end_controls_section();
