<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'apsro-addon'),
        'default' => __('Default Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'apsro-addon'),
        'default' => __('Default Sub Title', 'apsro-addon'),
    ]
);

apsro_elementor_heading_option($this, 'Section Sub Title', 'p', 'layout_one');

$this->add_control(
    'sec_summary',
    [
        'label' => __('Section Summary', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add summary', 'apsro-addon'),
        'default' => __('Default Summary', 'apsro-addon'),
    ]
);

$this->add_control(
    'rating_title',
    [
        'label' => __('Rating Title', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add rating title', 'apsro-addon'),
        'default' => __('4.9 Average Rating ', 'apsro-addon'),
    ]
);

$this->add_control(
    'rating',
    [
        'label' => __('Average Rating', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 5,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 5,
        ],
    ]
);

$this->add_control(
    'testimonial_section_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$testimonial = new \Elementor\Repeater();

$testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Kevin martin', 'apsro-addon'),
        'label_block' => true
    ]
);

apsro_elementor_heading_option($testimonial, 'Testimonial Title', 'h3', 'layout_one');

$testimonial->add_control(
    'designation',
    [
        'label' => __('Designation', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Customer', 'apsro-addon'),
        'label_block' => true
    ]
);

$testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'apsro-addon'),
    ]
);

$testimonial->add_control(
    'icon',
    [
        'label' => __('Icon', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-quote',
            'library' => 'Custom Icon',
        ],
    ]
);

$this->add_control(
    'testimonials',
    [
        'label' => __('Testimonial Items', 'apsro-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);

$this->add_control(
    'testimonial_image_hr',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'background_shape',
    [
        'label' => __('Background Shape', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'image_one',
    [
        'label' => __('Image One', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'image_two',
    [
        'label' => __('Image Two', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->end_controls_section();
