<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$layout_three_testimonial = new \Elementor\Repeater();

$layout_three_testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Kevin martin', 'apsro-addon'),
        'label_block' => true
    ]
);


$layout_three_testimonial->add_control(
    'designation',
    [
        'label' => __('Designation', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Customer', 'apsro-addon'),
        'label_block' => true
    ]
);


$layout_three_testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'apsro-addon'),
    ]
);


$layout_three_testimonial->add_control(
    'image',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_testimonial->add_control(
    'quotation_image',
    [
        'label' => __('Quotation', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_three_testimonials',
    [
        'label' => __('Testimonial Items', 'apsro-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);

$this->add_control(
    'layout_three_bg_image',
    [
        'label' => __('Background Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
