<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'apsro-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$layout_two_testimonial = new \Elementor\Repeater();

$layout_two_testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'default' => __('Dainl christine <span> . Co founder</span>', 'apsro-addon'),
        'label_block' => true
    ]
);

apsro_elementor_heading_option($layout_two_testimonial, 'Testimonial Name', 'h3', 'layout_two');

$layout_two_testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'apsro-addon'),
    ]
);

$layout_two_testimonial->add_control(
    'image',
    [
        'label' => __('Image', 'apsro-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_two_testimonials',
    [
        'label' => __('Testimonial Items', 'apsro-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);


$this->end_controls_section();
