<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!--About One Start-->
	<section class="about-one">
		<div class="container">
			<div class="row">
				<div class="col-xl-6 col-lg-5">
					<div class="about-one__left">
						<div class="about-one__img-box">
							<div class="about-one__img">
								<?php apsro_elementor_rendered_image($settings, 'layout_one_image'); ?>
							</div>
							<div class="about-one__icon">
								<?php \Elementor\Icons_Manager::render_icon($settings['layout_one_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
							</div>
							<div class="about-one__shape-1 shape-mover">
								<?php apsro_elementor_rendered_image($settings, 'layout_one_shape'); ?>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-6 col-lg-7">
					<div class="about-one__right">
						<div class="section-title text-left">
							<?php
							if (!empty($settings['sec_sub_title'])) :
								$this->add_inline_editing_attributes('sec_sub_title', 'none');
								apsro_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
							endif;

							if (!empty($settings['sec_title'])) :
								$this->add_inline_editing_attributes('sec_title', 'none');
								apsro_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
							endif;
							?>
						</div>
						<?php
						if (!empty($settings['highlighted_text'])) :
							apsro_basic_rendered_content($this, $settings,  'highlighted_text', 'about-one__text-1', 'p');
						endif;
						if (!empty($settings['summary'])) :
							apsro_basic_rendered_content($this, $settings,  'summary', 'about-one__text-2', 'p');
						endif;
						?>
						<ul class="about-one__points list-unstyled ml-0">
							<?php
							foreach ($settings['layout_one_check_list'] as $index => $item) : ?>
								<li>
									<div class="about-one__icon-and-title">
										<div class="about-one__points-icon">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="about-one__points-title">
											<?php
											if (!empty($item['title'])) :
												apsro_basic_rendered_content($this, $item,  'title', '', 'h3');
											endif;
											?>
										</div>
									</div>
									<?php
									if (!empty($item['subtitle'])) :
										apsro_basic_rendered_content($this, $item,  'subtitle', 'about-one__points-text', 'p');
									endif;
									?>
								</li>
							<?php
							endforeach; ?>
						</ul>
						<?php if (!empty($settings['layout_one_progress_title'] || $settings['layout_one_progress_number'])) : ?>
							<div class="about-one__progress">
								<?php
								if (!empty($settings['layout_one_progress_title'])) :
									$this->add_inline_editing_attributes('layout_one_progress_title', 'none');
									apsro_elementor_rendered_content($this, 'layout_one_progress_title', 'about-one__progress-title', $settings['progress_title_tag_layout_one']);
								endif;
								?>
								<div class="bar">
									<div class="bar-inner count-bar" data-percent="<?php echo esc_attr($settings['layout_one_progress_number']); ?>">
										<div class="count-text"><?php echo esc_html($settings['layout_one_progress_number']); ?></div>
									</div>
								</div>
							</div>
						<?php endif; ?>
						<div class="about-one__btn-and-user-box">
							<?php if (!empty($settings['button_label'])) : ?>
								<div class="about-one__btn-box">
									<?php
									apsro_basic_rendered_content($this, $settings,  'button_label', 'about-one__btn thm-btn', 'a', 'button_url', '');
									?>
								</div>
							<?php endif; ?>
							<?php if (!empty($settings['layout_one_client_image'] && $settings['layout_one_client_name'] && $settings['layout_one_client_designation'])) : ?>
								<div class="about-one__user-box">
									<div class="about-one__user-img">
										<?php apsro_elementor_rendered_image($settings, 'layout_one_client_image'); ?>
									</div>
									<div class="about-one__user-content">
										<?php
										if (!empty($settings['layout_one_client_name'])) :
											$this->add_inline_editing_attributes('layout_one_client_name', 'none');
											apsro_elementor_rendered_content($this, 'layout_one_client_name', '', 'h4');
										endif;

										if (!empty($settings['layout_one_client_designation'])) :
											$this->add_inline_editing_attributes('layout_one_client_designation', 'none');
											apsro_elementor_rendered_content($this, 'layout_one_client_designation', '', 'p');
										endif;
										?>
									</div>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--About One End-->

<?php endif; ?>