<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!--About Three Start-->
    <section class="about-three">
        <div class="container">
            <div class="row">
                <div class="col-xl-6">
                    <div class="about-three__left">
                        <div class="about-three__img-box">
                            <div class="about-three__img">
                                <?php apsro_elementor_rendered_image($settings, 'layout_three_image_one'); ?>
                            </div>
                            <div class="about-three__img-2">
                                <?php apsro_elementor_rendered_image($settings, 'layout_three_image_two'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="about-three__right">
                        <div class="section-title text-left">
                            <?php
                            if (!empty($settings['layout_three_sec_sub_title'])) :
                                $this->add_inline_editing_attributes('layout_three_sec_sub_title', 'none');
                                apsro_elementor_rendered_content($this, 'layout_three_sec_sub_title', 'section-title__tagline', 'p');
                            endif;

                            if (!empty($settings['layout_three_sec_title'])) :
                                $this->add_inline_editing_attributes('layout_three_sec_title', 'none');
                                apsro_elementor_rendered_content($this, 'layout_three_sec_title', 'section-title__title', $settings['section_title_tag_layout_three']);
                            endif;
                            ?>
                        </div>
                        <?php
                        if (!empty($settings['layout_three_summary'])) :
                            apsro_basic_rendered_content($this, $settings,  'layout_three_summary', 'about-three__text', 'p');
                        endif;
                        ?>
                        <?php foreach ($settings['layout_three_progress_bar'] as $item) : ?>
                            <div class="about-three__progress">
                                <h4 class="about-three__progress-title"><?php echo esc_html($item['title']); ?></h4>
                                <div class="bar">
                                    <div class="bar-inner count-bar" data-percent="<?php echo esc_html($item['progress_count']['size']); ?>%">
                                        <div class="count-text"><?php echo esc_html($item['progress_count']['size']); ?>%</div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        <ul class="about-three__points list-unstyled ml-0">
                            <?php foreach ($settings['layout_three_feature_list'] as $item) : ?>
                                <li>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                    </div>
                                    <div class="text">
                                        <?php
                                        if (!empty($item['title'])) :
                                            apsro_basic_rendered_content($this, $item,  'title', '', 'p');
                                        endif;
                                        ?>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        <?php if (!empty($settings['layout_three_button_label'])) : ?>
                            <div class="about-three__btn-box">
                                <?php
                                apsro_basic_rendered_content($this, $settings,  'layout_three_button_label', 'about-two__btn thm-btn', 'a', 'button_three_button_url', '');
                                ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--About Three End-->

<?php endif; ?>