<?php if ('layout_two' == $settings['layout_type']) : ?>

    <!--Awards Two Start-->
    <section class="awards-two">
        <div class="container">
            <div class="section-title text-left">
                <?php
                if (!empty($settings['layout_two_sec_sub_title'])) :
                    $this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
                    apsro_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'section-title__tagline', 'p');
                endif;

                if (!empty($settings['layout_two_sec_title'])) :
                    $this->add_inline_editing_attributes('layout_two_sec_title', 'none');
                    apsro_elementor_rendered_content($this, 'layout_two_sec_title', 'section-title__title', $settings['section_title_tag_layout_two']);
                endif;
                ?>
            </div>
            <div class="awards-two__awards-box">
                <ul class="awards-two__awards-list list-unstyled ml-0">
                    <?php
                    foreach ($settings['award_list_layout_two'] as $item) : ?>
                        <li>
                            <div class="awards-two__name-and-year">
                                <div class="awards-two__name-box">
                                    <div class="awards-two__name">
                                        <?php
                                        if (!empty($item['number'])) :
                                            apsro_basic_rendered_content($this, $item,  'number', '', 'p');
                                        endif;
                                        ?>
                                    </div>
                                    <?php
                                    if (!empty($item['title'])) :
                                        apsro_basic_rendered_content($this, $item,  'title', 'awards-two__text', 'p');
                                    endif;
                                    ?>
                                </div>
                                <div class="awards-two__year">
                                    <?php
                                    if (!empty($item['year'])) :
                                        apsro_basic_rendered_content($this, $item,  'year', '', 'span');
                                    endif;
                                    ?>
                                </div>
                            </div>
                            <?php if (!empty($item['url']['url'])) : ?>
                                <div class="awards-two__arrow">
                                    <a href="<?php echo esc_url($item['url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a>
                                </div>
                            <?php endif; ?>
                        </li>
                    <?php
                    endforeach; ?>
                </ul>
            </div>
        </div>
    </section>
    <!--Awards Two End -->
<?php endif; ?>