<?php if ('layout_four' == $settings['layout_type']) : ?>
	<!--BLog One Start-->
	<section class="blog-one">
		<div class="container">
			<div class="row">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				$i = 1;

				while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$comments_number = get_comments_number();
					$user = wp_get_current_user();
					$author_id = get_the_author_meta('ID');
					$author_img = get_avatar_url($author_id, array("size" => 40));
				?>
					<!--Blog One Single Start-->
					<div class="col-xl-4 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
						<div class="blog-one__single">
							<div class="blog-one__img-box">
								<div class="blog-one__img">
									<?php the_post_thumbnail('apsro_blog_370X283'); ?>
									<a href="blog-details.html">
										<span class="blog-one__plus"></span>
									</a>
									<div class="blog-one__date">
										<p><?php echo get_the_date('d'); ?>
											<br> <?php echo get_the_date('M'); ?>
										</p>
									</div>
								</div>
								<div class="blog-one__content-top">
									<div class="blog-one__content-img">
										<img src="<?php echo esc_url($author_img); ?>" alt="<?php echo bloginfo('name') ?>">
									</div>
									<p class="blog-one__content-sub-title"><?php echo esc_html("by", 'apsro'); ?> <?php echo esc_html(get_the_author()); ?></p>
									<h3 class="blog-one__content-title">
										<a href="<?php the_permalink(); ?>">
											<?php the_title(); ?>
										</a>
									</h3>
								</div>
							</div>
							<div class="blog-one__content">
								<div class="blog-one__comment-and-btn">
									<div class="blog-one__comment">
										<?php apsro_comment_count(); ?>
									</div>
									<div class="blog-one__btn">
										<a href="<?php the_permalink(); ?>">
											<?php \Elementor\Icons_Manager::render_icon($settings['blog_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
											<?php echo esc_html($settings['read_more']); ?>
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!--Blog One Single End-->
				<?php $i++;
				endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php apsro_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--BLog One End-->
<?php endif; ?>