<?php if ('layout_three' == $settings['layout_type']) : ?>

	<!--Blog Two Start-->
	<section class="blog-two">
		<div class="container">
			<div class="section-title text-center">
				<?php
				if (!empty($settings['sec_sub_title'])) :
					$this->add_inline_editing_attributes('sec_sub_title', 'none');
					apsro_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
				endif;

				if (!empty($settings['sec_title'])) :
					$this->add_inline_editing_attributes('sec_title', 'none');
					apsro_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
				endif;
				?>
			</div>
			<div class="row">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				$i = 1;

				while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$comments_number = get_comments_number();
					$user = wp_get_current_user();
					$author_id = get_the_author_meta('ID');
					$author_img = get_avatar_url($author_id, array("size" => 40));
				?>
					<!--Blog Two Single Start-->
					<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
						<div class="blog-two__single">
							<div class="blog-two__img-box">
								<div class="blog-two__img">
									<?php the_post_thumbnail('apsro_blog_370X485'); ?>
									<div class="blog-two__date">
										<p><?php echo get_the_date('d'); ?>
											<br> <?php echo get_the_date('M'); ?>
										</p>
									</div>
									<h3 class="blog-two__title">
										<a href="<?php the_permalink(); ?>">
											<?php the_title(); ?>
										</a>
									</h3>
								</div>
							</div>
							<div class="blog-two__comment-and-btn">
								<div class="blog-two__comment">
									<?php apsro_comment_count(); ?>
								</div>
								<div class="blog-one__btn">
									<a href="<?php the_permalink(); ?>">
										<?php \Elementor\Icons_Manager::render_icon($settings['blog_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										<?php echo esc_html($settings['read_more']); ?>
									</a>
								</div>
							</div>
						</div>
					</div>
					<!--Blog Two Single End-->
				<?php $i++;
				endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php apsro_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!--Blog Two End-->


<?php endif; ?>