<?php if ('layout_four' == $settings['layout_type']) : ?>
    <!--Contact Page Start-->
    <section class="contact-page">
        <div class="container">
            <div class="row">
                <div class="col-xl-5 col-lg-6">
                    <div class="contact-page__left">
                        <div class="section-title text-left">
                            <?php
                            if (!empty($settings['layout_four_sec_sub_title'])) :
                                $this->add_inline_editing_attributes('layout_four_sec_sub_title', 'none');
                                apsro_elementor_rendered_content($this, 'layout_four_sec_sub_title', 'section-title__tagline', 'p');
                            endif;

                            if (!empty($settings['layout_four_sec_title'])) :
                                $this->add_inline_editing_attributes('layout_four_sec_title', 'none');
                                apsro_elementor_rendered_content($this, 'layout_four_sec_title', 'section-title__title', $settings['section_title_tag_layout_four']);
                            endif;
                            ?>
                        </div>
                        <ul class="contact-page__points list-unstyled ml-0">
                            <?php foreach ($settings['layout_four_contact_info'] as $info) : ?>
                                <li>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon($info['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                    </div>
                                    <div class="content">
                                        <?php
                                        if (!empty($info['contact_title'])) :
                                            apsro_basic_rendered_content($this, $info,  'contact_title', '', 'p');
                                        endif;

                                        if (!empty($info['contact_number'])) :
                                            apsro_basic_rendered_content($this, $info,  'contact_number', '', 'h4');
                                        endif;
                                        ?>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        <div class="contact-page__social">
                            <?php foreach ($settings['layout_four_social'] as $social_icon) : ?>
                                <a href="<?php echo esc_url($social_icon['social_url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?></a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-7 col-lg-6">
                    <div class="contact-page__right">
                        <div class="contact-page__form-box">
                            <?php echo str_replace("<br />", "", trim(do_shortcode('[contact-form-7 id="' . $settings['layout_four_select_wpcf7_form'] . '" ]'))); ?>
                            <div class="result"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Contact Page End-->
<?php endif; ?>