<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Contact Details Start-->
    <section class="contact-details">
        <div class="container">
            <div class="contact-details__inner">
                <div class="contact-details__inner-content">
                    <div class="contact-details__shape-1 float-bob-y">
                        <?php apsro_elementor_rendered_image($settings, 'background_image_one'); ?>
                    </div>
                    <ul class="list-unstyled contact-details__list ml-0">
                        <?php
                        foreach ($settings['layout_one_info_items'] as $key => $item) :
                        ?>
                            <li>
                                <div class="icon icon-svg-large">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                </div>
                                <div class="content">
                                    <?php
                                    if (!empty($item['title'])) :
                                        apsro_basic_rendered_content($this, $item,  'title', '', 'p');
                                    endif;
                                    ?>
                                    <?php
                                    if (!empty($item['content'])) :
                                        apsro_basic_rendered_content($this, $item,  'content', '', $item['content_tag_layout_one']);
                                    endif;
                                    ?>
                                </div>
                            </li>
                        <?php endforeach; ?>
                        <li>
                            <div class="contact-details__social">
                                <?php foreach ($settings['layout_one_social'] as $social_icon) : ?>
                                    <a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!--Contact Details End-->


<?php endif; ?>