<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!--FAQ Page Start-->
	<section class="faq-page">
		<div class="container">
			<?php if (!empty($settings['sec_sub_title'] || $settings['sec_title'])) : ?>
				<div class="section-title text-left">
					<?php
					if (!empty($settings['sec_sub_title'])) :
						$this->add_inline_editing_attributes('sec_sub_title', 'none');
						apsro_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', 'p');
					endif;

					if (!empty($settings['sec_title'])) :
						$this->add_inline_editing_attributes('sec_title', 'none');
						apsro_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
					endif;
					?>
				</div>
			<?php endif; ?>
			<div class="row">
				<div class="col-xl-3 col-lg-4">
					<div class="faq-page__left">
						<div class="faq-page__contact-box">
							<div class="faq-page__contact-bg" style="background-image: url(<?php echo esc_url($settings['contact_box_image']['url']); ?>);">
							</div>
							<div class="faq-page__contact-icon">
								<?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
							</div>
							<?php
							if (!empty($settings['contact_box_title'])) :
								$this->add_inline_editing_attributes('contact_box_title', 'none');
								apsro_elementor_rendered_content($this, 'contact_box_title', 'faq-page__contact-title', $settings['contact_title_tag_layout_one']);
							endif;
							?>
							<div class="faq-page__call">
								<?php
								if (!empty($settings['contact_box_sub_title'])) :
									$this->add_inline_editing_attributes('contact_box_sub_title', 'none');
									apsro_elementor_rendered_content($this, 'contact_box_sub_title', 'faq-page__call-sub-title', 'p');
								endif;

								if (!empty($settings['contact_box_info'])) :
									$this->add_inline_editing_attributes('contact_box_info', 'none');
									apsro_elementor_rendered_content($this, 'contact_box_info', 'faq-page__call-number', 'h5');
								endif;
								?>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-9 col-lg-8">
					<div class="faq-page__right">
						<div class="accrodion-grp" data-grp-name="faq-one-accrodion">
							<?php
							$last_key = array_key_last($settings['faq_lists']);
							foreach ($settings['faq_lists'] as $key => $item) :
							?>
								<div class="accrodion <?php echo esc_attr(('yes' == $item['active_status'] ? 'active' : '')); ?>">
									<div class="accrodion-title">
										<?php
										if (!empty($item['question'])) :
											apsro_basic_rendered_content($this, $item,  'question', '', $item['question_title_tag_layout_one']);
										endif;
										?>
									</div>
									<div class="accrodion-content">
										<div class="inner">
											<?php
											if (!empty($item['answer'])) :
												apsro_basic_rendered_content($this, $item,  'answer', '', 'p');
											endif;
											?>
										</div><!-- /.inner -->
									</div>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--FAQ Page End-->
<?php endif; ?>