<?php if ('layout_one' == $settings['layout_type']) : ?>

  <div class="footer-widget__column footer-widget__newsletter">
    <div class="footer-widget__title-box">
      <?php
      if (!empty($settings['title'])) :
        $this->add_inline_editing_attributes('title', 'none');
        apsro_elementor_rendered_content($this, 'title', 'footer-widget__title', $settings['widget_title_tag_layout_one']);
      endif;
      ?>
    </div>
    <?php
    if (!empty($settings['text'])) :
      $this->add_inline_editing_attributes('text', 'none');
      apsro_elementor_rendered_content($this, 'text', 'footer-widget__newsletter-text', 'p');
    endif;
    ?>
    <form class="footer-widget__email-box mc-form" data-url="<?php echo esc_html($settings['mailchimp_url']); ?>">
      <div class="footer-widget__email-input-box">
        <input type="email" placeholder="<?php echo esc_attr($settings['mc_input_placeholder']); ?>" name="email">
      </div>
      <button type="submit" class="footer-widget__btn"><i class="fas fa-paper-plane"></i></button>
    </form>
    <div class="mc-form__response"></div>

    <div class="site-footer__social">
      <?php foreach ($settings['layout_one_social'] as $social_icon) : ?>
        <a href="<?php echo esc_url($social_icon['social_url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?></a>
      <?php endforeach; ?>
    </div>

  </div>

<?php endif; ?>