<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="site-footer__top">
        <div class="container">
            <div class="site-footer__top-inner">
                <div class="site-footer__top-left">
                    <div class="site-footer__top-icon icon-svg-large">
                        <?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                    </div>
                    <div class="site-footer__top-content">
                        <<?php echo esc_attr($settings['title_tag_layout_one']); ?>>
                            <?php echo esc_html($settings['title']); ?> <span><?php echo esc_html($settings['content']); ?></span>
                        </<?php echo esc_attr($settings['title_tag_layout_one']); ?>>
                    </div>
                </div>
                <div class="site-footer__top-right">
                    <div class="site-footer__social-shape-1 float-bob-y">
                        <?php apsro_elementor_rendered_image($settings, 'shape', 'zoom-fade'); ?>
                    </div>
                    <div class="site-footer__social-title">
                        <p><?php echo esc_html($settings['social_title']); ?></p>
                    </div>
                    <div class="site-footer__social">
                        <?php foreach ($settings['social_icons'] as $social_icon) : ?>
                            <a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
                                <?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>