<?php if ('layout_one' === $settings['layout_type']) : ?>

    <!-- Main Sllider Start -->
    <section class="main-slider">
        <?php if ($settings['slider_one_phone']) : ?>
            <div class="main-slider__phone">
                <?php echo wp_kses($settings['slider_one_phone'], 'apsro_allowed_tags'); ?>
            </div>
        <?php endif; ?>
        <?php if ($settings['slider_one_mail']) : ?>
            <div class="main-slider__mail">
                <?php echo wp_kses($settings['slider_one_mail'], 'apsro_allowed_tags'); ?>
            </div>
        <?php endif; ?>
        <div class="main-slider__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='{"loop": <?php echo esc_attr(('yes' == $settings['loop']) ? 'true' : 'false'); ?>, "items": <?php echo esc_attr($settings['items']['size']); ?>, "navText": ["<span class=\"icon-left-arrow\"></span>","<span class=\"icon-right-arrow\"></span>"], "margin": 0, "dots": true, "nav": false, "animateOut": "slideOutDown", "animateIn": "fadeIn", "active": true, "smartSpeed": 1000, "autoplay": true, "autoplayTimeout": 7000, "autoplayHoverPause": false}'>
            <?php
            foreach ($settings['sliders'] as $index => $slider) :
            ?>
                <div class="item main-slider__slide-1">
                    <div class="main-slider__bg" style="background-image: url(<?php echo esc_url($slider['background_image']['url']); ?>);">
                    </div><!-- /.slider-one__bg -->
                    <div class="container">
                        <div class="main-slider__content">
                            <?php
                            if (!empty($slider['star_icon'])) :
                                apsro_basic_rendered_content($this, $slider,  'star_icon', 'main-slider__star', 'p');
                            endif;
                            ?>
                            <div class="main-slider__text-box">
                                <?php
                                if (!empty($slider['sub_title'])) :
                                    apsro_basic_rendered_content($this, $slider,  'sub_title', 'main-slider__text', 'p');
                                endif;
                                ?>
                            </div>
                            <<?php echo esc_attr($slider['title_tag_layout_one']); ?> class="main-slider__title"><?php echo wp_kses($slider['title'], 'apsro_allowed_tags'); ?> <a href="<?php echo esc_url($slider['button_url']['url']); ?>" class="main-slider__btn"> <?php \Elementor\Icons_Manager::render_icon($slider['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?></a>
                            </<?php echo esc_attr($slider['title_tag_layout_one']); ?>>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
    <!--Main Sllider Start -->



<?php endif; ?>