<?php if ('layout_two' === $settings['layout_type']) : ?>
	<!-- Main Sllider Two Start -->
	<section class="main-slider-two">
		<?php if ($settings['slider_two_phone']) : ?>
			<div class="main-slider-two__phone">
				<?php echo wp_kses($settings['slider_two_phone'], 'apsro_allowed_tags'); ?>
			</div>
		<?php endif; ?>
		<?php if ($settings['slider_two_phone']) : ?>
			<div class="main-slider-two__mail">
				<?php echo wp_kses($settings['slider_two_mail'], 'apsro_allowed_tags'); ?>
			</div>
		<?php endif; ?>
		<div class="main-slider-two__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='{"loop": <?php echo esc_attr(('yes' == $settings['loop']) ? 'true' : 'false'); ?>, "items": <?php echo esc_attr($settings['items']['size']); ?>, "navText": ["<span class=\"icon-left-arrow\"></span>","<span class=\"icon-right-arrow\"></span>"], "margin": 0, "dots": false, "nav": false, "animateOut": "fadeOut", "animateIn": "fadeIn", "active": true, "smartSpeed": 1000, "autoplay": true, "autoplayTimeout": 7000, "autoplayHoverPause": false}'>

			<?php
			$i = 1;
			foreach ($settings['layout_two_sliders'] as $slider) : ?>
				<div class="item main-slider-two__slide-<?php echo esc_attr($i); ?>">
					<div class="main-slider-two__bg" style="background-image: url(<?php echo esc_url($slider['background_image']['url']); ?>);">
					</div><!-- /.slider-one__bg -->
					<div class="main-slider-two__img">
						<?php apsro_elementor_rendered_image($slider, 'image_one'); ?>
					</div>
					<div class="main-slider-two__shape-1">
						<?php apsro_elementor_rendered_image($slider, 'shape_one'); ?>
					</div>
					<div class="container">
						<div class="main-slider-two__content">
							<div class="main-slider-two__shape-2">
								<?php apsro_elementor_rendered_image($slider, 'shape_two'); ?>
							</div>
							<?php
							if (!empty($slider['sub_title'])) :
								apsro_basic_rendered_content($this, $slider,  'sub_title', 'main-slider-two__sub-title', 'p');
							endif;
							?>
							<div class="main-slider-two__title-box">
								<?php
								if (!empty($slider['title'])) :
									apsro_basic_rendered_content($this, $slider,  'title', 'main-slider-two__title-1', $slider['title_tag_layout_two']);
								endif;
								?>
								<h2 class="main-slider-two__title-2">
									<?php if (!empty($slider['url']['url'])) : ?>
										<a href="<?php echo esc_url($slider['url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($slider['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a>
									<?php endif; ?>
									<?php echo wp_kses($slider['title_two'], 'apsro_allowed_tags'); ?>
								</h2>
							</div>
							<div class="main-slider-two__small-img">
								<?php apsro_elementor_rendered_image($slider, 'image_two'); ?>
							</div>
						</div>
					</div>
				</div>
			<?php $i++;
			endforeach; ?>
		</div>
	</section>
	<!--Main Sllider Two End-->
<?php endif; ?>