<?php if ('layout_three' == $settings['layout_type']) : ?>

    <!--Portfolio-Three Start -->
    <section class="portfolio-three">
        <div class="container">
            <div class="section-title text-center">
                <?php
                if (!empty($settings['layout_three_sec_sub_title'])) :
                    $this->add_inline_editing_attributes('layout_three_sec_sub_title', 'none');
                    apsro_elementor_rendered_content($this, 'layout_three_sec_sub_title', 'section-title__tagline', 'p');
                endif;

                if (!empty($settings['layout_three_sec_title'])) :
                    $this->add_inline_editing_attributes('layout_three_sec_title', 'none');
                    apsro_elementor_rendered_content($this, 'layout_three_sec_title', 'section-title__title', $settings['section_title_tag_layout_three']);
                endif;
                ?>
            </div>
            <ul class="list-unstyled portfolio-three__list ml-0">
                <?php foreach ($settings['portfolio_three_list'] as $index => $item) :  ?>
                    <li>
                        <div class="portfolio-three__single">
                            <div class="portfolio-three__img" style="background-image:url(<?php echo esc_url($item['image']['url']); ?>);">
                                <div class="portfolio-three__title-box">
                                    <<?php echo esc_attr($item['portfolio_title_tag_layout_three']); ?> class="portfolio-three__title">
                                        <?php
                                        if (!empty($item['title'])) :
                                            apsro_basic_rendered_content($this, $item,  'title', '', 'a');
                                        endif;
                                        ?>
                                    </<?php echo esc_attr($item['portfolio_title_tag_layout_three']); ?>>
                                </div>
                                <div class="portfolio-three__count"></div>
                            </div>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </section>
    <!--Portfolio-Three End -->

<?php endif; ?>