<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!--Portfolio Two Start-->
    <section class="portfolio-two">
        <div class="container">
            <div class="section-title text-left">
                <?php
                if (!empty($settings['layout_two_sec_sub_title'])) :
                    $this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
                    apsro_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'section-title__tagline', 'p');
                endif;

                if (!empty($settings['layout_two_sec_title'])) :
                    $this->add_inline_editing_attributes('layout_two_sec_title', 'none');
                    apsro_elementor_rendered_content($this, 'layout_two_sec_title', 'section-title__title', $settings['section_title_tag_layout_two']);
                endif;
                ?>
            </div>
            <div class="portfolio-two__inner">
                <ul class="portfolio-two__list list-unstyled ml-0">
                    <?php $i = 1;
                    foreach ($settings['portfolio_two_list'] as $index => $item) :  ?>
                        <li>
                            <div class="portfolio-two__list-content">
                                <span>
                                    <?php if ($i > 9) {
                                        echo esc_attr($i);
                                        echo esc_attr("/");
                                    } else {
                                        echo esc_attr("0");
                                        echo $i;
                                        echo esc_attr("/");
                                    }
                                    ?>
                                </span>
                                <p>
                                    <?php
                                    if (!empty($item['title'])) :
                                        apsro_basic_rendered_content($this, $item,  'title', '', 'a');
                                    endif;
                                    ?>
                                </p>
                            </div>
                            <?php if (!empty($item['url']['url'])) : ?>
                                <div class="portfolio-two__list-arrow">
                                    <a href="<?php echo esc_html($item['url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a>
                                </div>
                            <?php endif; ?>
                            <div class="portfolio-two__img-1">
                                <?php apsro_elementor_rendered_image($item, 'image'); ?>
                            </div>
                        </li>
                    <?php $i++;
                    endforeach; ?>
                </ul>
            </div>
        </div>
    </section>
    <!--Portfolio Two End-->
<?php endif; ?>