<?php if ('layout_five' === $settings['layout_type']) : ?>

	<!--Services Three Start-->
	<section class="services-three">
		<?php if (!empty($settings['layout_five_bg_image']['url'])) : ?>
			<div class="services-three__bg-box">
				<div class="services-three__bg" style="background-image: url(<?php echo esc_url($settings['layout_five_bg_image']['url']); ?>);"></div>
			</div>
		<?php endif; ?>
		<div class="container">
			<div class="services-three__top">
				<div class="row">
					<div class="col-xl-6 col-lg-6">
						<div class="services-three__left">
							<div class="section-title text-left">
								<?php
								if (!empty($settings['layout_five_sec_sub_title'])) :
									$this->add_inline_editing_attributes('layout_five_sec_sub_title', 'none');
									apsro_elementor_rendered_content($this, 'layout_five_sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_five']);
								endif;

								if (!empty($settings['layout_five_sec_title'])) :
									$this->add_inline_editing_attributes('layout_five_sec_title', 'none');
									apsro_elementor_rendered_content($this, 'layout_five_sec_title', 'section-title__title', $settings['section_title_tag_layout_five']);
								endif;
								?>
							</div>
						</div>
					</div>
					<div class="col-xl-6 col-lg-6">
						<div class="services-three__right">
							<?php
							if (!empty($settings['layout_five_summary'])) :
								$this->add_inline_editing_attributes('layout_five_summary', 'none');
								apsro_elementor_rendered_content($this, 'layout_five_summary', 'services-three__text', 'p');
							endif;
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="services-three__bottom">
				<div class="row">
					<?php
					$i = 1;
					foreach ($settings['layout_five_service_items'] as $index => $item) :
					?>
						<!--Services Three Single Start-->
						<div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
							<div class="services-three__single">
								<div class="services-three__img-box">
									<div class="services-three__img">
										<?php apsro_elementor_rendered_image($item, 'image'); ?>
									</div>
									<div class="services-three__icon icon-svg-large">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
								</div>
								<div class="services-three__content">
									<div class="services-three__content-inner">
										<div class="services-three__content-top">
											<<?php echo esc_attr($item['service_title_tag_layout_five']); ?> class="services-three__title">
												<?php
												if (!empty($item['title'])) :
													apsro_basic_rendered_content($this, $item,  'title', '', 'a');
												endif;
												?>
											</<?php echo esc_attr($item['service_title_tag_layout_five']); ?>>
											<?php
											if (!empty($item['summary'])) :
												apsro_basic_rendered_content($this, $item,  'summary', 'services-three__text', 'p');
											endif;
											?>
										</div>
										<div class="services-three__btn-box">
											<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="services-three__btn">
												<?php \Elementor\Icons_Manager::render_icon($item['btn_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?><?php echo esc_html($item['btn_text']); ?>
											</a>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!--Services Three Single Start-->
					<?php
					endforeach; ?>
				</div>
			</div>
		</div>
	</section>
	<!--Services Three End-->

<?php endif; ?>