<?php if ('layout_three' === $settings['layout_type']) : ?>
	<!--Services Three Start-->
	<section class="services-three">
		<div class="services-three__bg" style="background-image: url(<?php echo esc_url($settings['layout_three_bg_image']['url']); ?>);"></div>
		<div class="container">
			<div class="services-three__top">
				<div class="row">
					<div class="col-xl-7 col-lg-6">
						<div class="services-three__left">
							<div class="section-title text-left">
								<?php
								if (!empty($settings['layout_three_sec_sub_title'])) :
									$this->add_inline_editing_attributes('layout_three_sec_sub_title', 'none');
									apsro_elementor_rendered_content($this, 'layout_three_sec_sub_title', 'section-title__tagline', 'p');
								endif;

								if (!empty($settings['layout_three_sec_title'])) :
									$this->add_inline_editing_attributes('layout_three_sec_title', 'none');
									apsro_elementor_rendered_content($this, 'layout_three_sec_title', 'section-title__title', $settings['section_title_tag_layout_three']);
								endif;
								?>
							</div>
						</div>
					</div>
					<div class="col-xl-5 col-lg-6">
						<div class="services-three__right">
							<?php
							if (!empty($settings['layout_three_sec_summary'])) :
								$this->add_inline_editing_attributes('layout_three_sec_summary', 'none');
								apsro_elementor_rendered_content($this, 'layout_three_sec_summary', 'services-three__text', 'p');
							endif;
							?>
						</div>
					</div>
				</div>
			</div>
			<div class="services-three__bottom">
				<ul class="services-three__services-list list-unstyled ml-0">
					<?php
					$i = 1;
					foreach ($settings['layout_three_service_items'] as $index => $item) :
					?>
						<li>
							<div class="services-three__single wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
								<div class="services-three__single-inner">
									<div class="services-three__single-bg" style="background-image: url(<?php echo esc_url($item['image']['url']); ?>);">
									</div>
									<div class="services-three__icon">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
									</div>
									<<?php echo esc_attr($item['service_title_tag_layout_three']); ?> class="services-three__title">
										<?php
										if (!empty($item['title'])) :
											apsro_basic_rendered_content($this, $item,  'title', '', 'a');
										endif;
										?>
									</<?php echo esc_attr($item['service_title_tag_layout_three']); ?>>
								</div>
							</div>
						</li>
					<?php
						$i++;
					endforeach; ?>
				</ul>
			</div>
		</div>
	</section>
	<!--Services Three End -->
<?php endif; ?>