<?php if ('layout_two' === $settings['layout_type']) : ?>
	<!--Services Two Start-->
	<section class="services-two">
		<div class="services-two__bg" style="background-image: url(<?php echo esc_url($settings['layout_two_image']['url']); ?>);">
		</div>
		<div class="container">
			<div class="row">
				<div class="col-xl-6 col-lg-6">
					<div class="services-two__left">
						<div class="section-title text-left">
							<?php
							if (!empty($settings['layout_two_sec_sub_title'])) :
								$this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
								apsro_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'section-title__tagline', 'p');
							endif;

							if (!empty($settings['layout_two_sec_title'])) :
								$this->add_inline_editing_attributes('layout_two_sec_title', 'none');
								apsro_elementor_rendered_content($this, 'layout_two_sec_title', 'section-title__title', $settings['section_title_tag_layout_two']);
							endif;
							?>
						</div>
						<?php
						if (!empty($settings['layout_two_summary'])) :
							$this->add_inline_editing_attributes('layout_two_summary', 'none');
							apsro_elementor_rendered_content($this, 'layout_two_summary', 'services-two__text', 'p');
						endif;
						?>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="services-two__right">
						<div class="row">
							<?php
							$i = 1;
							foreach ($settings['layout_two_service_items'] as $index => $item) :
							?>
								<!--Services Two Single Start-->
								<div class="col-xl-6 wow fadeInLeft" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
									<div class="services-two__single">
										<div class="services-two__title">
											<a href="<?php echo esc_url($item['url']['url']); ?>">
												<?php echo wp_kses($item['title'], 'apsro_allowed_tags'); ?>
											</a>
										</div>
										<div class="services-two__icon">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
									</div>
								</div>
								<!--Services Two Single End-->
							<?php
							endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Services Two End-->

<?php endif; ?>