<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!--Tabs One Start-->
	<section class="tabs-one">
		<div class="container">
			<div class="tabs-one__inner tabs-box">
				<?php if (!empty($settings['shape']['url'])) : ?>
					<div class="tabs-one__shape-1 float-bob-x">
						<?php apsro_elementor_rendered_image($settings, 'shape'); ?>
					</div>
				<?php endif; ?>
				<ul class="tab-buttons clearfix list-unstyled ml-0">
					<?php
					$i = 1;
					foreach ($settings['tab_list'] as $index => $item) : ?>
						<li data-tab="#tab_one<?php echo esc_attr($i); ?>" class="tab-btn <?php echo esc_attr($i == 1 ? 'active-btn' : ''); ?>"><span><?php echo esc_html($item['title']); ?></span>
						</li>
					<?php
						$i++;
					endforeach; ?>
				</ul>

				<div class="tabs-content">
					<?php
					$i = 1;
					foreach ($settings['tab_list'] as $index => $item) : ?>
						<!--tab-->
						<div class="tab <?php echo esc_attr($i == 1 ? 'active-tab' : ''); ?>" id="tab_one<?php echo esc_attr($i); ?>">
							<div class="tabs-one__tab-content-inner">
								<div class="tabs-one__tab-content-left">
									<div class="tabs-one__img">
										<?php apsro_elementor_rendered_image($item, 'image'); ?>
									</div>
									<div class="tabs-one__content">
										<?php
										if (!empty($item['title'])) :
											apsro_basic_rendered_content($this, $item,  'title', '', $item['title_tag_layout_one']);
										endif;
										?>
										<?php
										if (!empty($item['summary'])) :
											apsro_basic_rendered_content($this, $item,  'summary', '', 'p');
										endif;
										?>
									</div>
								</div>
								<div class="tabs-one__points">
									<ul class="tabs-one__points-list list-unstyled ml-0">
										<?php echo wp_kses_post($item['feature']); ?>
									</ul>
								</div>
							</div>
						</div>
						<!--tab-->
					<?php
						$i++;
					endforeach; ?>
				</div>
			</div>
		</div>
	</section>
	<!--Tabs One End -->

<?php endif; ?>