<?php if ('layout_one' == $settings['layout_type']) : ?>

	<!--Team One Start-->
	<section class="team-one">
		<div class="container">
			<div class="section-title text-center">
				<?php
				if (!empty($settings['sec_sub_title'])) :
					$this->add_inline_editing_attributes('sec_sub_title', 'none');
					apsro_elementor_rendered_content($this, 'sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_one']);
				endif;

				if (!empty($settings['sec_title'])) :
					$this->add_inline_editing_attributes('sec_title', 'none');
					apsro_elementor_rendered_content($this, 'sec_title', 'section-title__title', $settings['section_title_tag_layout_one']);
				endif;
				?>
			</div>
			<div class="row">
				<?php
				$counter = 1;
				foreach ($settings['team_items'] as $item) : ?>
					<!--Team One Single Start-->
					<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($counter); ?>00ms">
						<div class="team-one__single">
							<div class="team-one__img-box">
								<div class="team-one__img">
									<?php apsro_elementor_rendered_image($item, 'image'); ?>
								</div>
								<?php if (!empty($item['social_network'])) : ?>
									<div class="team-one__share-btn">
										<a href="team-details.html"><span class="fas fa-share-alt"></span></a>
										<ul class="list-unstyled team-one__social ml-0">
											<?php echo wp_kses($item['social_network'], 'apsro_allowed_tags'); ?>
										</ul>
									</div>
								<?php endif; ?>
							</div>
							<div class="team-one__content">
								<div class="team-one__name-box">
									<<?php echo esc_attr($item['team_name_tag_layout_one']); ?>>
										<?php
										if (!empty($item['name'])) :
											apsro_basic_rendered_content($this, $item,  'name', '', 'a');
										endif;
										?>
									</<?php echo esc_attr($item['team_name_tag_layout_one']); ?>>
									<?php
									if (!empty($item['designation'])) :
										apsro_basic_rendered_content($this, $item,  'designation', '', 'p');
									endif;
									?>
								</div>
								<?php if (!empty($item['url']['url'])) : ?>
									<div class="team-one__arrow">
										<a href="<?php echo esc_url($item['url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<!--Team One Single End-->
				<?php $counter++;
				endforeach; ?>
			</div>
		</div>
	</section>
	<!--Team One End-->
<?php endif; ?>