<?php if ('layout_three' == $settings['layout_type']) : ?>

	<!--Team Details Start-->
	<section class="team-details">
		<div class="container">
			<div class="row">
				<div class="col-xl-5 col-lg-5">
					<div class="team-details__left">
						<div class="team-details__img">
							<?php apsro_elementor_rendered_image($settings, 'layout_three_image'); ?>
						</div>
						<div class="team-details__social-box">
							<div class="team-details__social-title">
								<p><?php echo esc_html($settings['layout_three_social_title']); ?></p>
							</div>
							<div class="team-details__social">
								<?php foreach ($settings['layout_three_social'] as $social_icon) : ?>
									<a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
										<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
									</a>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-7 col-lg-7">
					<div class="team-details__right">
						<?php
						if (!empty($settings['layout_three_title'])) :
							$this->add_inline_editing_attributes('layout_three_title', 'none');
							apsro_elementor_rendered_content($this, 'layout_three_title', 'team-details__title', $settings['title_tag_layout_three']);
						endif;
						?>
						<?php
						if (!empty($settings['layout_three_summary'])) :
							$this->add_inline_editing_attributes('layout_three_summary', 'none');
							apsro_elementor_rendered_content($this, 'layout_three_summary', 'team-details__text', 'p');
						endif;
						?>
						<div class="team-details__points-box">
							<h3 class="team-details__points-title"><?php echo esc_html($settings['layout_three_feature_title']); ?></h3>
							<ul class="team-details__points list-unstyled ml-0">
								<?php foreach ($settings['layout_three_features_list'] as $index => $item) : ?>
									<li>
										<div class="icon">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<?php
										if (!empty($item['title'])) :
											apsro_basic_rendered_content($this, $item,  'title', '', 'h4');
										endif;
										?>
									</li>
								<?php endforeach; ?>
							</ul>
						</div>
						<div class="team-details__btn-box">
							<?php
							if (!empty($settings['layout_three_button_label'])) :
								apsro_basic_rendered_content($this, $settings,  'layout_three_button_label', 'team-details__btn thm-btn', 'a', 'layout_three_button_url', '');
							endif;
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Team Details End-->

<?php endif; ?>