<?php if ('layout_two' == $settings['layout_type']) : ?>

	<!--Team Page Start-->
	<section class="team-page">
		<div class="container">
			<div class="row">
				<?php
				foreach ($settings['layout_two_team_items'] as $index => $item) : ?>
					<!--Team One Single Start-->
					<div class="col-xl-4 col-lg-4 col-md-6">
						<div class="team-one__single">
							<div class="team-one__img-box">
								<div class="team-one__img">
									<?php apsro_elementor_rendered_image($item, 'image'); ?>
								</div>
								<div class="team-one__share-btn">
									<a href="team-details.html"><span class="fas fa-share-alt"></span></a>
									<ul class="list-unstyled team-one__social ml-0">
										<?php echo wp_kses($item['social_network'], 'apsro_allowed_tags'); ?>
									</ul>
								</div>
							</div>
							<div class="team-one__content">
								<div class="team-one__name-box">
									<<?php echo esc_attr($item['team_name_tag_layout_two']); ?>>
										<?php
										if (!empty($item['name'])) :
											apsro_basic_rendered_content($this, $item,  'name', '', 'a');
										endif;
										?>
									</<?php echo esc_attr($item['team_name_tag_layout_two']); ?>>
									<?php
									if (!empty($item['designation'])) :
										apsro_basic_rendered_content($this, $item,  'designation', '', 'p');
									endif;
									?>
								</div>
								<?php if (!empty($item['url']['url'])) : ?>
									<div class="team-one__arrow">
										<a href="<?php echo esc_url($item['url']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?></a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<!--Team One Single End-->
				<?php
				endforeach; ?>
			</div>
		</div>
	</section>
	<!--Team Page End-->

<?php endif; ?>